	clear all
	close all
	clc
	% 5th-band polyphase filter, linear phase
	L = 5; wcT = 0.139*pi; Amin = 60; 
	x = -0.5*ones(1,8); 		% Initial poles on the negative real axis
	vub = 0.999*ones(1,8); 		% Lower bounds
	vlb = -0.999*ones(1,8);		% Upper bounds
 	wT = [linspace(2*pi/L-wcT,2*pi/L+wcT,500), linspace(4*pi/L-wcT,4*pi/L+wcT,500)];
	ewT = exp(i*wT);	eLwT = exp(i*L*wT);
	x = minimax('Ex_14_15_fun', x, [], vlb, vub, [], ewT, eLwT);
%	x = fminimax('Ex_14_15_fun', x, [], vlb, vub, [], ewT, eLwT); Newer
	wT = linspace(0,pi,1000);
	%======
	if 1==1
		x(1) = -0.32991114218279; x(2) = 0.15260283981161;
		x(3) = -0.50832673044661; x(4) = 0.14541508826241;
		x(5) = -0.66879592375456; x(6) = 0.10977707264645;
		x(7) = -0.82901629233741; x(8) = 0.05954173448975;
	end
	%======	
	ewT = exp(i*wT);	eLwT = exp(i*L*wT);	
	[H, H0, H1, H2, H3, H4] = LTH_BAND_14_15_H(x, ewT, eLwT);
	p1 = [x(1), x(2)]	% Poles in the first-order sections
	p2 = [x(3), x(4)]
	p3 = [x(5), x(6)]
	p4 = [x(7), x(8)]
		
	Att = H_2_ATT((H0+H1+H2+H3+H4)/5);
	subplot('position', [0.1 0.4 0.88 0.5]);
	PLOT_ATT_Z(wT, Att, pi, 70)
	axes('position',[0.72 0.52 0.2 0.15]);
	PLOT_ATT_Z(wT, Att, 0.139*pi, 5*10^-4)
	
	figure(2), subplot(3,1,1)
	wT = linspace(0, wcT, 500);
	ewT = exp(i*wT);	eLwT = exp(i*L*wT);	
	[H, H0, H1, H2, H3, H4] = LTH_BAND_14_15_H(x, ewT, eLwT);
	d = 9;
	Ph_error = unwrap(angle(H)+d*wT);
	PLOT_PHASE_ERROR_Z(wT, Ph_error, -0.01*pi, 0.01*pi)
	subplot(3,1,2);
	Taug = LTH_BAND_14_15_TAUG(x, wT);
	PLOT_TG_Z(wT, Taug, 8.5, 10)
